/*
 * Decompiled with CFR 0.152.
 */
package org.hamcrest.collection;

import java.util.Arrays;
import java.util.List;
import org.hamcrest.AbstractMatcherTest;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.StringDescription;
import org.hamcrest.collection.IsIn;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IsInTest
extends AbstractMatcherTest {
    String[] elements = new String[]{"a", "b", "c"};

    @Override
    protected Matcher<?> createMatcher() {
        return new IsIn((Object[])this.elements);
    }

    public void testReturnsTrueIfArgumentIsInCollection() {
        List<String> collection = Arrays.asList(this.elements);
        IsIn isIn = new IsIn(collection);
        IsInTest.assertMatches("a", isIn, "a");
        IsInTest.assertMatches("b", isIn, "b");
        IsInTest.assertMatches("c", isIn, "c");
        IsInTest.assertDoesNotMatch("d", isIn, "d");
    }

    public void testReturnsTrueIfArgumentIsInArray() {
        IsIn isIn = new IsIn((Object[])this.elements);
        IsInTest.assertMatches("a", isIn, "a");
        IsInTest.assertMatches("b", isIn, "b");
        IsInTest.assertMatches("c", isIn, "c");
        IsInTest.assertDoesNotMatch("d", isIn, "d");
    }

    public void testHasReadableDescription() {
        IsIn isIn = new IsIn((Object[])this.elements);
        IsInTest.assertEquals((String)"description", (String)"one of {\"a\", \"b\", \"c\"}", (String)StringDescription.toString((SelfDescribing)isIn));
    }
}

